// Triangle.h: Schnittstelle fr die Klasse CTriangle.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TRIANGLE_H__1F824621_844B_11D1_8F4C_106273C1105F__INCLUDED_)
#define AFX_TRIANGLE_H__1F824621_844B_11D1_8F4C_106273C1105F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "glTexFont.h"
#include <math.h>

class CTriangle  
{
public:
	CTriangle();
	virtual ~CTriangle();
public:
	// Three vertices of the triangle
	float m_Vertices[3][3];
	// Normal of the triangle
	float m_Normal[3];
	// Calculate the anti-planes of the triangle
	void CalcAntiPlanes();
	// Calculate the triangle's normal
	void CalcNormal();
	// Checks if a object that moves from fPointBefore to fPointAfter will collide
	// with the triangle. Returns TRUE in case of collision
	bool CheckCollision(const float fPointBefore[], const float fPointAfter[]);
//private:
	// Calculate unit vector 
	void ReduceToUnit(float vector[]);
	// Calculate the normal from a given triangle
	void CalcNormal(const float v[][3], float out[]);
	// Calculates the distance from a point to an infinite plane
	// that is described by one vertex and its normal
	float GetInfinitePlaneDistance(const float fPlaneVertex[], const float fPoint[], const float fNormal[]);
	// Checks the point against the anti-planes of the triangle.
	// Returns true if the distance to all planes is positive	
	bool CheckAntiPlaneDistance(const float fPoint[]);
	// Calculates the distance from a point to an infinite plane that is
	// described by one vertex and its normal from the class's member data
	float GetInfinitePlaneDistance(const float fPoint[]);
	// Take the cross product of two vectors 
	void CrossProduct(const float v1[],const float v2[], float out[]);
	// Vertex coordinates of the three anti-planes of the triangle
	float m_AntiPlane1[3];
	float m_AntiPlane2[3];
	float m_AntiPlane3[3];
	// Normals of the three anti-planes
	float m_AntiPlane1Normal[3];
	float m_AntiPlane2Normal[3];
	float m_AntiPlane3Normal[3];
};

#endif // !defined(AFX_TRIANGLE_H__1F824621_844B_11D1_8F4C_106273C1105F__INCLUDED_)
